@guest
<div class="row g-4">
    <div class="col-md-6">
        <label for="full-name" class="form-label">@lang('app.full-name') <span class="text-danger">*</span></label>
        <input required type="text" class="form-control @error('name') is-invalid @enderror" name="name" value="{{old('name')}}" id="full-name" placeholder="Full Name">
        @error('name')
        <em class="text-danger">{{$message}}</em>
        @enderror
    </div>
    <div class="col-md-6">
        <label for="email" class="form-label">@lang('app.email') <span class="text-danger">*</span></label>
        <input required type="email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{old('email')}}" id="email" placeholder="Email">
        @error('email')
        <em class="text-danger">{{$message}}</em>
        @enderror
    </div>
    <div class="col-md-6">
        <label for="phone" class="form-label">@lang('app.phone') <span class="text-danger">*</span></label>
        <input required type="text" class="form-control @error('phone') is-invalid @enderror" name="phone" value="{{old('phone')}}" id="phone" placeholder="Your Phone" onkeyup="this.value = this.value.replace (/^\.|[^\d\.]/g, '')">
        @error('phone')
        <em class="text-danger">{{$message}}</em>
        @enderror
    </div>
    <x-location-picker class="my-3"/>
    <div class="col-md-6">
        <label for="Address-Line1" class="form-label">@lang('app.address-line1') <span class="text-danger">*</span></label>
        <input required type="text" class="form-control @error('address_one') is-invalid @enderror" name="address_one" value="{{old('address_one')}}" id="Address-Line1" placeholder="Your Address Line 1">
        @error('address_one')
        <em class="text-danger">{{$message}}</em>
        @enderror
    </div>
    <div class="col-md-6">
        <label for="Address-Line2" class="form-label">@lang('app.address-line2')</label>
        <input type="text" class="form-control @error('address_two') is-invalid @enderror" name="address_two" value="{{old('address_two')}}" id="Address-Line2" placeholder="Your Address Line 2">
        @error('address_two')
        <em class="text-danger">{{$message}}</em>
        @enderror
    </div>
    <div class="col-md-6">
        <label for="postal" class="form-label">@lang('app.postal') <span class="text-danger">*</span></label>
        <input required type="text" class="form-control @error('postal') is-invalid @enderror" name="postal" value="{{old('postal')}}" id="postal" placeholder="ZIP code/Postal code">
        @error('postal')
        <em class="text-danger">{{$message}}</em>
        @enderror
    </div>
    <div class="col-md-12">
        <label for="message" class="form-label">@lang('app.message')</label>
        <textarea class="form-control @error('message') is-invalid @enderror" id="message" name="message" rows="5" placeholder="Message">{{old('message')}}</textarea>
        @error('message')
        <em class="text-danger">{{$message}}</em>
        @enderror
    </div>
</div>
@else
<input type="hidden" name="user_id" value="{{user()->id}}">
<div class="contact-part">
    <h5 class="userName">{{user()->name}}</h5>
    <p class="userInformation"><span>Email: </span>{{user()->email}}</p>
    <p class="userInformation"><span>Phone: </span>{{user()->phone}}</p>
</div>
@endguest
